' Structure utilitaire pour la taille d'une police.
Enum TheFontSize
    Huge = 30
    Normal = 20
    Tiny = 8
End Enum


Public Class Form1
    Inherits System.Windows.Forms.Form

    ' Taille actuelle de la police.
    Private currFontSize As Integer = TheFontSize.Normal

    ' Le menu contextuel du formulaire.
    Private popUpMenu As ContextMenu


    ' Utilis pour garder une trace de l'objet actuellement activ.
    Private currentCheckedItem As MenuItem      ' Marque l'objet activ.
    Private checkedHuge As MenuItem
    Private checkedNormal As MenuItem
    Private checkedTiny As MenuItem

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        ' Pour commencer on construit le menu contextuel.
        popUpMenu = New ContextMenu()

        ' Maintenant on ajoute les sous-objets et on attache le menu contextuel. 
        popUpMenu.MenuItems.Add("Grande", _
             New EventHandler(AddressOf PopUp_Clicked))
        popUpMenu.MenuItems.Add("Normale", _
             New EventHandler(AddressOf PopUp_Clicked))
        popUpMenu.MenuItems.Add("Petite", _
             New EventHandler(AddressOf PopUp_Clicked))

        Me.ContextMenu = popUpMenu

        ' Affecter chaque MenuItem au bon sous-menu.
        checkedHuge = Me.ContextMenu.MenuItems(0)
        checkedNormal = Me.ContextMenu.MenuItems(1)
        checkedTiny = Me.ContextMenu.MenuItems(2)

        ' Maintenant marquer l'objet de menu "Normal".
        currentCheckedItem = checkedNormal
        currentCheckedItem.Checked = True

        CenterToScreen()
    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(464, 117)
        Me.Name = "Form1"
        Me.Text = "Formulaire Menu Pop Up"

    End Sub

#End Region

    Private Sub PopUp_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        ' Dsactiver l'objet actuellement actif.
        currentCheckedItem.Checked = False

        ' Rcuprer la chane reprsentant le nom de l'objet slectionn.
        Dim miClicked As MenuItem = CType(sender, MenuItem)
        Dim item As String = miClicked.Text

        If (item = "Grande") Then
            currFontSize = TheFontSize.Huge
            currentCheckedItem = checkedHuge
        End If
        If (item = "Normale") Then
            currFontSize = TheFontSize.Normal
            currentCheckedItem = checkedNormal
        End If
        If (item = "Petite") Then
            currFontSize = TheFontSize.Tiny
            currentCheckedItem = checkedTiny
        End If

        ' Maintenant la valider.
        currentCheckedItem.Checked = True

        Invalidate()
    End Sub


    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim g As Graphics = e.Graphics
        g.DrawString("S'il vous plat, cliquez sur moi...", _
             New Font("Times New Roman", currFontSize), _
             New SolidBrush(Color.Black), _
             10, 10)
    End Sub
End Class
